# Repozytorium kodu
**Statystyka praktyczna w data science. Wydanie II**  

Ponad 50 podstawowych koncepcji w R i Pythonie

Peter Bruce, Andrew Bruce i [Peter Gedeck](https://www.amazon.com/Peter-Gedeck/e/B082BJZJKX/)

- Wydawnictwo: O'Reilly Media; wydanie II (9 czerwca 2020)
- ISBN-13: 978-1492072942
- Errata: http://oreilly.com/catalog/errata.csp?isbn=9781492072942

## R
Za pomocą poniższych poleceń zainstalujesz w R wszystkie wymagane pakiety:
```
if (!require(vioplot)) install.packages('vioplot')
if (!require(corrplot)) install.packages('corrplot')
if (!require(gmodels)) install.packages('gmodels')
if (!require(matrixStats)) install.packages('matrixStats')

if (!require(lmPerm)) install.packages('lmPerm')
if (!require(pwr)) install.packages('pwr')

if (!require(FNN)) install.packages('FNN')
if (!require(klaR)) install.packages('klaR')
if (!require(DMwR)) install.packages('DMwR')

if (!require(xgboost)) install.packages('xgboost')

if (!require(ellipse)) install.packages('ellipse')
if (!require(mclust)) install.packages('mclust')
if (!require(ca)) install.packages('ca')
```

## Python
Zalecamy korzystanie ze środowiska conda podczas pracy z listingami w Pythonie. 
```
conda create -n sfds python
conda activate sfds

pip install jupyter
pip install pandas
pip install matplotlib
pip install scipy
pip install statsmodels
pip install wquantiles
pip install seaborn
pip install scikit-learn
pip install pygam
pip install dmba
pip install pydotplus

pip install imbalanced-learn
pip install prince

conda install --yes -c conda-forge xgboost
conda install --yes graphviz
```

## Materiały dodatkowe
- O'Reilly: https://oreil.ly/practicalStats_dataSci_2e
- Errata: http://oreilly.com/catalog/errata.csp?isbn=9781492072942
- Repozytorium kodu dla wydania pierwszego (po angielsku): https://github.com/andrewgbruce/statistics-for-data-scientists
